<?php

namespace Symfony\Config\Framework\Validation;


use Symfony\Component\Config\Loader\ParamConfigurator;
use Symfony\Component\Config\Definition\Exception\InvalidConfigurationException;


/**
 * This class is automatically generated to help creating config.
 */
class NotCompromisedPasswordConfig 
{
    private $enabled;
    private $endpoint;
    
    /**
     * When disabled, compromised passwords will be accepted as valid.
     * @default true
     * @param ParamConfigurator|bool $value
     * @return $this
     */
    public function enabled($value): self
    {
        $this->enabled = $value;
    
        return $this;
    }
    
    /**
     * API endpoint for the NotCompromisedPassword Validator.
     * @default null
     * @param ParamConfigurator|mixed $value
     * @return $this
     */
    public function endpoint($value): self
    {
        $this->endpoint = $value;
    
        return $this;
    }
    
    public function __construct(array $value = [])
    {
    
        if (isset($value['enabled'])) {
            $this->enabled = $value['enabled'];
            unset($value['enabled']);
        }
    
        if (isset($value['endpoint'])) {
            $this->endpoint = $value['endpoint'];
            unset($value['endpoint']);
        }
    
        if ([] !== $value) {
            throw new InvalidConfigurationException(sprintf('The following keys are not supported by "%s": ', __CLASS__).implode(', ', array_keys($value)));
        }
    }
    
    public function toArray(): array
    {
        $output = [];
        if (null !== $this->enabled) {
            $output['enabled'] = $this->enabled;
        }
        if (null !== $this->endpoint) {
            $output['endpoint'] = $this->endpoint;
        }
    
        return $output;
    }

}
