<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TStrategicObjectivesRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_strategic_objectives:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_strategic_objectives:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TStrategicObjectivesRepository::class)
 */

class TStrategicObjectives
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_strategic_objectives:read", "t_strategic_objectives:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_strategic_objectives:read", "t_strategic_objectives:write" })
     */
    private $name;

    /**
     * @ORM\ManyToOne(targetEntity=TPcs::class, inversedBy="tStrategicObjectives")
     */
    private $pc;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getPc(): ?TPcs
    {
        return $this->pc;
    }

    public function setPc(?TPcs $pc): self
    {
        $this->pc = $pc;

        return $this;
    }
}
