<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TSettingRepository;
use Doctrine\ORM\Mapping as ORM;

use Doctrine\Common\Collections\ArrayCollection;
use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_setting:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_setting:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TSettingRepository::class)
 */

class TSetting
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_setting:read", "t_setting:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_setting:read", "t_setting:write" })
     */
    private $institutionName;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_setting:read", "t_setting:write" })
     */
    private $businessMantra;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_setting:read", "t_setting:write" })
     */
    private $officialEmail;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_setting:read", "t_setting:write" })
     */
    private $smsApiKey;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_setting:read", "t_setting:write" })
     */
    private $smsApiProvider;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_setting:read", "t_setting:write" })
     */
    private $website;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({ "t_setting:read", "t_setting:write" })
     */
    private $phoneNo1;

    /**
     * @ORM\Column(type="string", length=15, nullable=true)
     * @Groups({ "t_setting:read", "t_setting:write" })
     */
    private $phoneNo2;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_setting:read", "t_setting:write" })
     */
    private $poBox;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_setting:read", "t_setting:write" })
     */
    private $phyAddress;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_setting:read", "t_setting:write" })
     */
    private $ourVision;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_setting:read", "t_setting:write" })
     */
    private $ourMission;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_setting:read", "t_setting:write" })
     */
    private $ourValues;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_setting:read", "t_setting:write" })
     */
    private $defaultMapLatitude;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_setting:read", "t_setting:write" })
     */
    private $defaultMapLongitude;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getInstitutionName(): ?string
    {
        return $this->institutionName;
    }

    public function setInstitutionName(?string $institutionName): self
    {
        $this->institutionName = $institutionName;

        return $this;
    }

    public function getBusinessMantra(): ?string
    {
        return $this->businessMantra;
    }

    public function setBusinessMantra(?string $businessMantra): self
    {
        $this->businessMantra = $businessMantra;

        return $this;
    }

    public function getOfficialEmail(): ?string
    {
        return $this->officialEmail;
    }

    public function setOfficialEmail(?string $officialEmail): self
    {
        $this->officialEmail = $officialEmail;

        return $this;
    }

    public function getSmsApiKey(): ?string
    {
        return $this->smsApiKey;
    }

    public function setSmsApiKey(?string $smsApiKey): self
    {
        $this->smsApiKey = $smsApiKey;

        return $this;
    }

    public function getSmsApiProvider(): ?string
    {
        return $this->smsApiProvider;
    }

    public function setSmsApiProvider(?string $smsApiProvider): self
    {
        $this->smsApiProvider = $smsApiProvider;

        return $this;
    }

    public function getWebsite(): ?string
    {
        return $this->website;
    }

    public function setWebsite(?string $website): self
    {
        $this->website = $website;

        return $this;
    }

    public function getPhoneNo1(): ?string
    {
        return $this->phoneNo1;
    }

    public function setPhoneNo1(?string $phoneNo1): self
    {
        $this->phoneNo1 = $phoneNo1;

        return $this;
    }

    public function getPhoneNo2(): ?string
    {
        return $this->phoneNo2;
    }

    public function setPhoneNo2(?string $phoneNo2): self
    {
        $this->phoneNo2 = $phoneNo2;

        return $this;
    }

    public function getPoBox(): ?string
    {
        return $this->poBox;
    }

    public function setPoBox(?string $poBox): self
    {
        $this->poBox = $poBox;

        return $this;
    }

    public function getPhyAddress(): ?string
    {
        return $this->phyAddress;
    }

    public function setPhyAddress(?string $phyAddress): self
    {
        $this->phyAddress = $phyAddress;

        return $this;
    }

    public function getOurVision(): ?string
    {
        return $this->ourVision;
    }

    public function setOurVision(?string $ourVision): self
    {
        $this->ourVision = $ourVision;

        return $this;
    }

    public function getOurMission(): ?string
    {
        return $this->ourMission;
    }

    public function setOurMission(?string $ourMission): self
    {
        $this->ourMission = $ourMission;

        return $this;
    }

    public function getOurValues(): ?string
    {
        return $this->ourValues;
    }

    public function setOurValues(?string $ourValues): self
    {
        $this->ourValues = $ourValues;

        return $this;
    }

    public function getDefaultMapLatitude(): ?string
    {
        return $this->defaultMapLatitude;
    }

    public function setDefaultMapLatitude(?string $defaultMapLatitude): self
    {
        $this->defaultMapLatitude = $defaultMapLatitude;

        return $this;
    }

    public function getDefaultMapLongitude(): ?string
    {
        return $this->defaultMapLongitude;
    }

    public function setDefaultMapLongitude(?string $defaultMapLongitude): self
    {
        $this->defaultMapLongitude = $defaultMapLongitude;

        return $this;
    }

}
