<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TSectorStrategiesRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_sector_strategies:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_sector_strategies:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "sector": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TSectorStrategiesRepository::class)
 */

class TSectorStrategies
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_sector_strategies:read", "t_sector_strategies:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_sector_strategies:read", "t_sector_strategies:write" })
     */
    private $name;

    /**
     * @ORM\ManyToOne(targetEntity=TSectorPriorities::class, inversedBy="tSectorStrategies")
     * @Groups({ "t_sector_strategies:read", "t_sector_strategies:write" })
     */
    private $sectorPriority;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tSectorStrategies")
     * @Groups({ "t_sector_strategies:read", "t_sector_strategies:write" })
     */
    private $sector;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getSectorPriority(): ?TSectorPriorities
    {
        return $this->sectorPriority;
    }

    public function setSectorPriority(?TSectorPriorities $sectorPriority): self
    {
        $this->sectorPriority = $sectorPriority;

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }
}
