<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TPcMatrixRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_pc_matrix:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_pc_matrix:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "pc": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TPcMatrixRepository::class)
 */

class TPcMatrix
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_pc_matrix:read", "t_pc_matrix:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_pc_matrix:read", "t_pc_matrix:write" })
     */
    private $planningStatement;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_pc_matrix:read", "t_pc_matrix:write" })
     */
    private $startDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_pc_matrix:read", "t_pc_matrix:write" })
     */
    private $endDate;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_pc_matrix:read", "t_pc_matrix:write" })
     */
    private $weight;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_pc_matrix:read", "t_pc_matrix:write" })
     */
    private $baseline;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_pc_matrix:read", "t_pc_matrix:write" })
     */
    private $annualTarget;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_pc_matrix:read", "t_pc_matrix:write" })
     */
    private $targetQ1;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_pc_matrix:read", "t_pc_matrix:write" })
     */
    private $targetQ2;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_pc_matrix:read", "t_pc_matrix:write" })
     */
    private $targetQ3;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_pc_matrix:read", "t_pc_matrix:write" })
     */
    private $targetQ4;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_pc_matrix:read", "t_pc_matrix:write" })
     */
    private $unitsOfMeasure;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_pc_matrix:read", "t_pc_matrix:write" })
     */
    private $meansOfVerification;

    /**
     * @ORM\ManyToOne(targetEntity=TPcs::class, inversedBy="tPcMatrices")
     * @Groups({ "t_pc_matrix:read", "t_pc_matrix:write" })
     */
    private $pc;

    /**
     * @ORM\ManyToOne(targetEntity=TKpas::class, inversedBy="tPcMatrices")
     * @Groups({ "t_pc_matrix:read", "t_pc_matrix:write" })
     */
    private $kpa;

    /**
     * @ORM\ManyToOne(targetEntity=TKfas::class, inversedBy="tPcMatrices")
     * @Groups({ "t_pc_matrix:read", "t_pc_matrix:write" })
     */
    private $kfa;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getPlanningStatement(): ?string
    {
        return $this->planningStatement;
    }

    public function setPlanningStatement(?string $planningStatement): self
    {
        $this->planningStatement = $planningStatement;

        return $this;
    }

    public function getStartDate(): ?\DateTimeInterface
    {
        return $this->startDate;
    }

    public function setStartDate(?\DateTimeInterface $startDate): self
    {
        $this->startDate = $startDate;

        return $this;
    }

    public function getEndDate(): ?\DateTimeInterface
    {
        return $this->endDate;
    }

    public function setEndDate(?\DateTimeInterface $endDate): self
    {
        $this->endDate = $endDate;

        return $this;
    }

    public function getWeight(): ?string
    {
        return $this->weight;
    }

    public function setWeight(?string $weight): self
    {
        $this->weight = $weight;

        return $this;
    }

    public function getBaseline(): ?string
    {
        return $this->baseline;
    }

    public function setBaseline(?string $baseline): self
    {
        $this->baseline = $baseline;

        return $this;
    }

    public function getAnnualTarget(): ?string
    {
        return $this->annualTarget;
    }

    public function setAnnualTarget(?string $annualTarget): self
    {
        $this->annualTarget = $annualTarget;

        return $this;
    }

    public function getTargetQ1(): ?string
    {
        return $this->targetQ1;
    }

    public function setTargetQ1(?string $targetQ1): self
    {
        $this->targetQ1 = $targetQ1;

        return $this;
    }

    public function getTargetQ2(): ?string
    {
        return $this->targetQ2;
    }

    public function setTargetQ2(?string $targetQ2): self
    {
        $this->targetQ2 = $targetQ2;

        return $this;
    }

    public function getTargetQ3(): ?string
    {
        return $this->targetQ3;
    }

    public function setTargetQ3(?string $targetQ3): self
    {
        $this->targetQ3 = $targetQ3;

        return $this;
    }

    public function getTargetQ4(): ?string
    {
        return $this->targetQ4;
    }

    public function setTargetQ4(?string $targetQ4): self
    {
        $this->targetQ4 = $targetQ4;

        return $this;
    }

    public function getUnitsOfMeasure(): ?string
    {
        return $this->unitsOfMeasure;
    }

    public function setUnitsOfMeasure(?string $unitsOfMeasure): self
    {
        $this->unitsOfMeasure = $unitsOfMeasure;

        return $this;
    }

    public function getMeansOfVerification(): ?string
    {
        return $this->meansOfVerification;
    }

    public function setMeansOfVerification(?string $meansOfVerification): self
    {
        $this->meansOfVerification = $meansOfVerification;

        return $this;
    }

    public function getPc(): ?TPcs
    {
        return $this->pc;
    }

    public function setPc(?TPcs $pc): self
    {
        $this->pc = $pc;

        return $this;
    }

    public function getKpa(): ?TKpas
    {
        return $this->kpa;
    }

    public function setKpa(?TKpas $kpa): self
    {
        $this->kpa = $kpa;

        return $this;
    }

    public function getKfa(): ?TKfas
    {
        return $this->kfa;
    }

    public function setKfa(?TKfas $kfa): self
    {
        $this->kfa = $kfa;

        return $this;
    }
}
