<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TMunicipalitiesRepository;
use Doctrine\ORM\Mapping as ORM;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_municipalities:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_municipalities:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "milestone": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TMunicipalitiesRepository::class)
 */

class TMunicipalities
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_municipalities:read", "t_municipalities:write", "t_county_departments_adp_projects:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_municipalities:read", "t_municipalities:write", "t_county_departments_adp_projects:read" })
     */
    private $name;

    /**
     * @ORM\OneToMany(targetEntity=TCountyDepartmentsAdpProjects::class, mappedBy="municipality")
     */
    private $tCountyDepartmentsAdpProjects;

    public function __construct()
    {
        $this->tCountyDepartmentsAdpProjects = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return Collection|TCountyDepartmentsAdpProjects[]
     */
    public function getTCountyDepartmentsAdpProjects(): Collection
    {
        return $this->tCountyDepartmentsAdpProjects;
    }

    public function addTCountyDepartmentsAdpProject(TCountyDepartmentsAdpProjects $tCountyDepartmentsAdpProject): self
    {
        if (!$this->tCountyDepartmentsAdpProjects->contains($tCountyDepartmentsAdpProject)) {
            $this->tCountyDepartmentsAdpProjects[] = $tCountyDepartmentsAdpProject;
            $tCountyDepartmentsAdpProject->setMunicipality($this);
        }

        return $this;
    }

    public function removeTCountyDepartmentsAdpProject(TCountyDepartmentsAdpProjects $tCountyDepartmentsAdpProject): self
    {
        if ($this->tCountyDepartmentsAdpProjects->removeElement($tCountyDepartmentsAdpProject)) {
            // set the owning side to null (unless already changed)
            if ($tCountyDepartmentsAdpProject->getMunicipality() === $this) {
                $tCountyDepartmentsAdpProject->setMunicipality(null);
            }
        }

        return $this;
    }
}
