<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TMilestonesNotesRepository;
use Doctrine\ORM\Mapping as ORM;

use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_milestones_notes:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_milestones_notes:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "milestone": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TMilestonesNotesRepository::class)
 */

class TMilestonesNotes
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_milestones_notes:read", "t_milestones_notes:write" })
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TMilestones::class, inversedBy="tMilestonesNotes")
     * @Groups({ "t_milestones_notes:read", "t_milestones_notes:write" })
     */
    private $milestone;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyStaffMembers::class, inversedBy="tMilestonesNotes")
     * @Groups({ "t_milestones_notes:read", "t_milestones_notes:write" })
     */
    private $staffMember;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_milestones_notes:read", "t_milestones_notes:write" })
     */
    private $activityDate;

    /**
     * @ORM\Column(type="time", nullable=true)
     * @Groups({ "t_milestones_notes:read", "t_milestones_notes:write" })
     */
    private $activityTime;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_milestones_notes:read", "t_milestones_notes:write" })
     */
    private $note;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_milestones_notes:read", "t_milestones_notes:write" })
     */
    private $activityName;

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getMilestone(): ?TMilestones
    {
        return $this->milestone;
    }

    public function setMilestone(?TMilestones $milestone): self
    {
        $this->milestone = $milestone;

        return $this;
    }

    public function getStaffMember(): ?TCountyStaffMembers
    {
        return $this->staffMember;
    }

    public function setStaffMember(?TCountyStaffMembers $staffMember): self
    {
        $this->staffMember = $staffMember;

        return $this;
    }

    public function getActivityDate(): ?\DateTimeInterface
    {
        return $this->activityDate;
    }

    public function setActivityDate(?\DateTimeInterface $activityDate): self
    {
        $this->activityDate = $activityDate;

        return $this;
    }

    public function getActivityTime(): ?\DateTimeInterface
    {
        return $this->activityTime;
    }

    public function setActivityTime(?\DateTimeInterface $activityTime): self
    {
        $this->activityTime = $activityTime;

        return $this;
    }

    public function getNote(): ?string
    {
        return $this->note;
    }

    public function setNote(?string $note): self
    {
        $this->note = $note;

        return $this;
    }

    public function getActivityName(): ?string
    {
        return $this->activityName;
    }

    public function setActivityName(?string $activityName): self
    {
        $this->activityName = $activityName;

        return $this;
    }
}
