<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use App\Repository\TGroupsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_groups:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_groups:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "type": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TGroupsRepository::class)
 */
class TGroups
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $groupName;

    /**
     * @ORM\Column(type="string", length=255)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $status;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $type;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $dashboarMain;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $dashboardHome;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $dashboardGraphical;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $dashboardsMaps;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $institutionView;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $sectorVisionMission;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $sectorResponsibilities;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $sectorPcObligations;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $sectorPriorities;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $sectorStrategies;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $sectorObjectives;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $sectorCidp;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $sectorAdps;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $departmentVisionMission;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $departmentResponsibilities;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $departmentPcObligations;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $departmentPriorities;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $departmentStrategies;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $departmentObjectives;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $departmentProjects;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $departmentProjectsMap;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $departmentProjectsImages;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $departmentProjectsStatus;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $directorateObjectives;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $directorateProjects;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $tasksPlanning;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $tasksDependancies;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $tasksVerifications;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $tasksValidations;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $tasksResults;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $tasksHistory;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $pcGovernorSign;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $pcCountySecSign;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $pcCecSign;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $pcCoSign;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $pcDirectorSign;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $pcUpdatingSign;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $apprisalAppraisee;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $apprisalSupervisor;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $reportsProjects;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $reportsMilestones;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $reportsPcs;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $reportsAppraisals;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $backOfficeOrganisation;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $backOfficeSecurity;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $backOfficeSettings;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $mainSectors;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $mainDepartments;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $mainDirectorates;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $mainMilestones;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $mainPcs;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $mainAppraisals;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $mainReports;

    /**
     * @ORM\Column(type="boolean", nullable=true)
     * @Groups({ "t_groups:read", "t_groups:write" })
     */
    private $mainBackOffice;

    public function __construct()
    {

    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getGroupName(): ?string
    {
        return $this->groupName;
    }

    public function setGroupName(string $groupName): self
    {
        $this->groupName = $groupName;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getType(): ?string
    {
        return $this->type;
    }

    public function setType(?string $type): self
    {
        $this->type = $type;

        return $this;
    }

    public function getDashboarMain(): ?bool
    {
        return $this->dashboarMain;
    }

    public function setDashboarMain(?bool $dashboarMain): self
    {
        $this->dashboarMain = $dashboarMain;

        return $this;
    }

    public function getDashboardHome(): ?bool
    {
        return $this->dashboardHome;
    }

    public function setDashboardHome(?bool $dashboardHome): self
    {
        $this->dashboardHome = $dashboardHome;

        return $this;
    }

    public function getDashboardGraphical(): ?bool
    {
        return $this->dashboardGraphical;
    }

    public function setDashboardGraphical(?bool $dashboardGraphical): self
    {
        $this->dashboardGraphical = $dashboardGraphical;

        return $this;
    }

    public function getDashboardsMaps(): ?bool
    {
        return $this->dashboardsMaps;
    }

    public function setDashboardsMaps(?bool $dashboardsMaps): self
    {
        $this->dashboardsMaps = $dashboardsMaps;

        return $this;
    }

    public function getInstitutionView(): ?bool
    {
        return $this->institutionView;
    }

    public function setInstitutionView(?bool $institutionView): self
    {
        $this->institutionView = $institutionView;

        return $this;
    }

    public function getSectorVisionMission(): ?bool
    {
        return $this->sectorVisionMission;
    }

    public function setSectorVisionMission(?bool $sectorVisionMission): self
    {
        $this->sectorVisionMission = $sectorVisionMission;

        return $this;
    }

    public function getSectorResponsibilities(): ?bool
    {
        return $this->sectorResponsibilities;
    }

    public function setSectorResponsibilities(?bool $sectorResponsibilities): self
    {
        $this->sectorResponsibilities = $sectorResponsibilities;

        return $this;
    }

    public function getSectorPcObligations(): ?bool
    {
        return $this->sectorPcObligations;
    }

    public function setSectorPcObligations(?bool $sectorPcObligations): self
    {
        $this->sectorPcObligations = $sectorPcObligations;

        return $this;
    }

    public function getSectorPriorities(): ?bool
    {
        return $this->sectorPriorities;
    }

    public function setSectorPriorities(?bool $sectorPriorities): self
    {
        $this->sectorPriorities = $sectorPriorities;

        return $this;
    }

    public function getSectorStrategies(): ?bool
    {
        return $this->sectorStrategies;
    }

    public function setSectorStrategies(?bool $sectorStrategies): self
    {
        $this->sectorStrategies = $sectorStrategies;

        return $this;
    }

    public function getSectorObjectives(): ?bool
    {
        return $this->sectorObjectives;
    }

    public function setSectorObjectives(?bool $sectorObjectives): self
    {
        $this->sectorObjectives = $sectorObjectives;

        return $this;
    }

    public function getSectorCidp(): ?bool
    {
        return $this->sectorCidp;
    }

    public function setSectorCidp(?bool $sectorCidp): self
    {
        $this->sectorCidp = $sectorCidp;

        return $this;
    }

    public function getSectorAdps(): ?bool
    {
        return $this->sectorAdps;
    }

    public function setSectorAdps(?bool $sectorAdps): self
    {
        $this->sectorAdps = $sectorAdps;

        return $this;
    }

    public function getDepartmentVisionMission(): ?bool
    {
        return $this->departmentVisionMission;
    }

    public function setDepartmentVisionMission(?bool $departmentVisionMission): self
    {
        $this->departmentVisionMission = $departmentVisionMission;

        return $this;
    }

    public function getDepartmentResponsibilities(): ?bool
    {
        return $this->departmentResponsibilities;
    }

    public function setDepartmentResponsibilities(?bool $departmentResponsibilities): self
    {
        $this->departmentResponsibilities = $departmentResponsibilities;

        return $this;
    }

    public function getDepartmentPcObligations(): ?bool
    {
        return $this->departmentPcObligations;
    }

    public function setDepartmentPcObligations(?bool $departmentPcObligations): self
    {
        $this->departmentPcObligations = $departmentPcObligations;

        return $this;
    }

    public function getDepartmentPriorities(): ?bool
    {
        return $this->departmentPriorities;
    }

    public function setDepartmentPriorities(?bool $departmentPriorities): self
    {
        $this->departmentPriorities = $departmentPriorities;

        return $this;
    }

    public function getDepartmentStrategies(): ?bool
    {
        return $this->departmentStrategies;
    }

    public function setDepartmentStrategies(?bool $departmentStrategies): self
    {
        $this->departmentStrategies = $departmentStrategies;

        return $this;
    }

    public function getDepartmentObjectives(): ?bool
    {
        return $this->departmentObjectives;
    }

    public function setDepartmentObjectives(?bool $departmentObjectives): self
    {
        $this->departmentObjectives = $departmentObjectives;

        return $this;
    }

    public function getDepartmentProjects(): ?bool
    {
        return $this->departmentProjects;
    }

    public function setDepartmentProjects(?bool $departmentProjects): self
    {
        $this->departmentProjects = $departmentProjects;

        return $this;
    }

    public function getDepartmentProjectsMap(): ?bool
    {
        return $this->departmentProjectsMap;
    }

    public function setDepartmentProjectsMap(?bool $departmentProjectsMap): self
    {
        $this->departmentProjectsMap = $departmentProjectsMap;

        return $this;
    }

    public function getDepartmentProjectsImages(): ?bool
    {
        return $this->departmentProjectsImages;
    }

    public function setDepartmentProjectsImages(?bool $departmentProjectsImages): self
    {
        $this->departmentProjectsImages = $departmentProjectsImages;

        return $this;
    }

    public function getDepartmentProjectsStatus(): ?bool
    {
        return $this->departmentProjectsStatus;
    }

    public function setDepartmentProjectsStatus(?bool $departmentProjectsStatus): self
    {
        $this->departmentProjectsStatus = $departmentProjectsStatus;

        return $this;
    }

    public function getDirectorateObjectives(): ?bool
    {
        return $this->directorateObjectives;
    }

    public function setDirectorateObjectives(?bool $directorateObjectives): self
    {
        $this->directorateObjectives = $directorateObjectives;

        return $this;
    }

    public function getDirectorateProjects(): ?bool
    {
        return $this->directorateProjects;
    }

    public function setDirectorateProjects(?bool $directorateProjects): self
    {
        $this->directorateProjects = $directorateProjects;

        return $this;
    }

    public function getTasksPlanning(): ?bool
    {
        return $this->tasksPlanning;
    }

    public function setTasksPlanning(?bool $tasksPlanning): self
    {
        $this->tasksPlanning = $tasksPlanning;

        return $this;
    }

    public function getTasksDependancies(): ?bool
    {
        return $this->tasksDependancies;
    }

    public function setTasksDependancies(?bool $tasksDependancies): self
    {
        $this->tasksDependancies = $tasksDependancies;

        return $this;
    }

    public function getTasksVerifications(): ?bool
    {
        return $this->tasksVerifications;
    }

    public function setTasksVerifications(?bool $tasksVerifications): self
    {
        $this->tasksVerifications = $tasksVerifications;

        return $this;
    }

    public function getTasksValidations(): ?bool
    {
        return $this->tasksValidations;
    }

    public function setTasksValidations(?bool $tasksValidations): self
    {
        $this->tasksValidations = $tasksValidations;

        return $this;
    }

    public function getTasksResults(): ?bool
    {
        return $this->tasksResults;
    }

    public function setTasksResults(?bool $tasksResults): self
    {
        $this->tasksResults = $tasksResults;

        return $this;
    }

    public function getTasksHistory(): ?bool
    {
        return $this->tasksHistory;
    }

    public function setTasksHistory(?bool $tasksHistory): self
    {
        $this->tasksHistory = $tasksHistory;

        return $this;
    }

    public function getPcGovernorSign(): ?bool
    {
        return $this->pcGovernorSign;
    }

    public function setPcGovernorSign(?bool $pcGovernorSign): self
    {
        $this->pcGovernorSign = $pcGovernorSign;

        return $this;
    }

    public function getPcCountySecSign(): ?bool
    {
        return $this->pcCountySecSign;
    }

    public function setPcCountySecSign(?bool $pcCountySecSign): self
    {
        $this->pcCountySecSign = $pcCountySecSign;

        return $this;
    }

    public function getPcCecSign(): ?bool
    {
        return $this->pcCecSign;
    }

    public function setPcCecSign(?bool $pcCecSign): self
    {
        $this->pcCecSign = $pcCecSign;

        return $this;
    }

    public function getPcCoSign(): ?bool
    {
        return $this->pcCoSign;
    }

    public function setPcCoSign(?bool $pcCoSign): self
    {
        $this->pcCoSign = $pcCoSign;

        return $this;
    }

    public function getPcDirectorSign(): ?bool
    {
        return $this->pcDirectorSign;
    }

    public function setPcDirectorSign(?bool $pcDirectorSign): self
    {
        $this->pcDirectorSign = $pcDirectorSign;

        return $this;
    }

    public function getPcUpdatingSign(): ?bool
    {
        return $this->pcUpdatingSign;
    }

    public function setPcUpdatingSign(?bool $pcUpdatingSign): self
    {
        $this->pcUpdatingSign = $pcUpdatingSign;

        return $this;
    }

    public function getApprisalAppraisee(): ?bool
    {
        return $this->apprisalAppraisee;
    }

    public function setApprisalAppraisee(?bool $apprisalAppraisee): self
    {
        $this->apprisalAppraisee = $apprisalAppraisee;

        return $this;
    }

    public function getApprisalSupervisor(): ?bool
    {
        return $this->apprisalSupervisor;
    }

    public function setApprisalSupervisor(?bool $apprisalSupervisor): self
    {
        $this->apprisalSupervisor = $apprisalSupervisor;

        return $this;
    }

    public function getReportsProjects(): ?bool
    {
        return $this->reportsProjects;
    }

    public function setReportsProjects(?bool $reportsProjects): self
    {
        $this->reportsProjects = $reportsProjects;

        return $this;
    }

    public function getReportsMilestones(): ?bool
    {
        return $this->reportsMilestones;
    }

    public function setReportsMilestones(?bool $reportsMilestones): self
    {
        $this->reportsMilestones = $reportsMilestones;

        return $this;
    }

    public function getReportsPcs(): ?bool
    {
        return $this->reportsPcs;
    }

    public function setReportsPcs(?bool $reportsPcs): self
    {
        $this->reportsPcs = $reportsPcs;

        return $this;
    }

    public function getReportsAppraisals(): ?bool
    {
        return $this->reportsAppraisals;
    }

    public function setReportsAppraisals(?bool $reportsAppraisals): self
    {
        $this->reportsAppraisals = $reportsAppraisals;

        return $this;
    }

    public function getBackOfficeOrganisation(): ?bool
    {
        return $this->backOfficeOrganisation;
    }

    public function setBackOfficeOrganisation(?bool $backOfficeOrganisation): self
    {
        $this->backOfficeOrganisation = $backOfficeOrganisation;

        return $this;
    }

    public function getBackOfficeSecurity(): ?bool
    {
        return $this->backOfficeSecurity;
    }

    public function setBackOfficeSecurity(?bool $backOfficeSecurity): self
    {
        $this->backOfficeSecurity = $backOfficeSecurity;

        return $this;
    }

    public function getBackOfficeSettings(): ?bool
    {
        return $this->backOfficeSettings;
    }

    public function setBackOfficeSettings(?bool $backOfficeSettings): self
    {
        $this->backOfficeSettings = $backOfficeSettings;

        return $this;
    }

    public function getMainSectors(): ?bool
    {
        return $this->mainSectors;
    }

    public function setMainSectors(?bool $mainSectors): self
    {
        $this->mainSectors = $mainSectors;

        return $this;
    }

    public function getMainDepartments(): ?bool
    {
        return $this->mainDepartments;
    }

    public function setMainDepartments(?bool $mainDepartments): self
    {
        $this->mainDepartments = $mainDepartments;

        return $this;
    }

    public function getMainDirectorates(): ?bool
    {
        return $this->mainDirectorates;
    }

    public function setMainDirectorates(?bool $mainDirectorates): self
    {
        $this->mainDirectorates = $mainDirectorates;

        return $this;
    }

    public function getMainMilestones(): ?bool
    {
        return $this->mainMilestones;
    }

    public function setMainMilestones(?bool $mainMilestones): self
    {
        $this->mainMilestones = $mainMilestones;

        return $this;
    }

    public function getMainPcs(): ?bool
    {
        return $this->mainPcs;
    }

    public function setMainPcs(?bool $mainPcs): self
    {
        $this->mainPcs = $mainPcs;

        return $this;
    }

    public function getMainAppraisals(): ?bool
    {
        return $this->mainAppraisals;
    }

    public function setMainAppraisals(?bool $mainAppraisals): self
    {
        $this->mainAppraisals = $mainAppraisals;

        return $this;
    }

    public function getMainReports(): ?bool
    {
        return $this->mainReports;
    }

    public function setMainReports(?bool $mainReports): self
    {
        $this->mainReports = $mainReports;

        return $this;
    }

    public function getMainBackOffice(): ?bool
    {
        return $this->mainBackOffice;
    }

    public function setMainBackOffice(?bool $mainBackOffice): self
    {
        $this->mainBackOffice = $mainBackOffice;

        return $this;
    }


}
