<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TCountyStaffMembersRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_county_staff_members:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_county_staff_members:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "position": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TCountyStaffMembersRepository::class)
 */

class TCountyStaffMembers
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_county_staff_members:read", "t_county_staff_members:write", "t_directors:read", "t_appraisals:read" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_county_staff_members:read", "t_county_staff_members:write", "t_governors:read", "t_cecs:read", "t_cos:read", "t_county_secretary:read", "t_appraisals:read", "t_directors:read", "t_pcs:read" })
     */
    private $firstName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_county_staff_members:read", "t_county_staff_members:write", "t_governors:read", "t_cecs:read", "t_cos:read", "t_county_secretary:read", "t_appraisals:read", "t_directors:read", "t_pcs:read" })
     */
    private $middleName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_county_staff_members:read", "t_county_staff_members:write", "t_governors:read", "t_cecs:read", "t_cos:read", "t_county_secretary:read", "t_appraisals:read", "t_directors:read", "t_pcs:read" })
     */
    private $lastName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_county_staff_members:read", "t_county_staff_members:write" })
     */
    private $idNumber;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_county_staff_members:read", "t_county_staff_members:write" })
     */
    private $status;

    /**
     * @ORM\ManyToOne(targetEntity=TStaffSalutations::class, inversedBy="tCountyStaffMembers")
     * @Groups({ "t_county_staff_members:read", "t_county_staff_members:write" })
     */
    private $staffSalutation;

    /**
     * @ORM\ManyToOne(targetEntity=TPositions::class, inversedBy="tCountyStaffMembers")
     * @Groups({ "t_county_staff_members:read", "t_county_staff_members:write" })
     */
    private $position;

    /**
     * @ORM\OneToMany(targetEntity=TGovernors::class, mappedBy="staffMember")
     */
    private $tGovernors;

    /**
     * @ORM\OneToMany(targetEntity=TCos::class, mappedBy="staffMember")
     */
    private $tCos;

    /**
     * @ORM\OneToMany(targetEntity=TCecs::class, mappedBy="staffMember")
     */
    private $tCecs;

    /**
     * @ORM\OneToMany(targetEntity=TCountySecretary::class, mappedBy="staffMember")
     */
    private $tCountySecretaries;

    /**
     * @ORM\OneToMany(targetEntity=TAppraisals::class, mappedBy="staffMember")
     */
    private $tAppraisals;

    /**
     * @ORM\OneToMany(targetEntity=TDirectors::class, mappedBy="staffMember")
     */
    private $tDirectors;

    /**
     * @ORM\Column(type="string", length=2500, nullable=true)
     * @Groups({ "t_county_staff_members:read", "t_county_staff_members:write" })
     */
    private $profilePhoto;

    /**
     * @ORM\OneToMany(targetEntity=TMilestonesNotes::class, mappedBy="staffMember")
     */
    private $tMilestonesNotes;

    /**
     * @ORM\OneToMany(targetEntity=TPcActivities::class, mappedBy="activityOwner")
     */
    private $tPcActivities;

    public function __construct()
    {
        $this->tGovernors = new ArrayCollection();
        $this->tCos = new ArrayCollection();
        $this->tCecs = new ArrayCollection();
        $this->tCountySecretaries = new ArrayCollection();
        $this->tAppraisals = new ArrayCollection();
        $this->tDirectors = new ArrayCollection();
        $this->tMilestonesNotes = new ArrayCollection();
        $this->tPcActivities = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getFirstName(): ?string
    {
        return $this->firstName;
    }

    public function setFirstName(?string $firstName): self
    {
        $this->firstName = $firstName;

        return $this;
    }

    public function getMiddleName(): ?string
    {
        return $this->middleName;
    }

    public function setMiddleName(?string $middleName): self
    {
        $this->middleName = $middleName;

        return $this;
    }

    public function getLastName(): ?string
    {
        return $this->lastName;
    }

    public function setLastName(?string $lastName): self
    {
        $this->lastName = $lastName;

        return $this;
    }

    public function getIdNumber(): ?string
    {
        return $this->idNumber;
    }

    public function setIdNumber(?string $idNumber): self
    {
        $this->idNumber = $idNumber;

        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $status): self
    {
        $this->status = $status;

        return $this;
    }

    public function getStaffSalutation(): ?TStaffSalutations
    {
        return $this->staffSalutation;
    }

    public function setStaffSalutation(?TStaffSalutations $staffSalutation): self
    {
        $this->staffSalutation = $staffSalutation;

        return $this;
    }

    public function getPosition(): ?TPositions
    {
        return $this->position;
    }

    public function setPosition(?TPositions $position): self
    {
        $this->position = $position;

        return $this;
    }

    /**
     * @return Collection|TGovernors[]
     */
    public function getTGovernors(): Collection
    {
        return $this->tGovernors;
    }

    public function addTGovernor(TGovernors $tGovernor): self
    {
        if (!$this->tGovernors->contains($tGovernor)) {
            $this->tGovernors[] = $tGovernor;
            $tGovernor->setStaffMember($this);
        }

        return $this;
    }

    public function removeTGovernor(TGovernors $tGovernor): self
    {
        if ($this->tGovernors->removeElement($tGovernor)) {
            // set the owning side to null (unless already changed)
            if ($tGovernor->getStaffMember() === $this) {
                $tGovernor->setStaffMember(null);
            }
        }

        return $this;
    }  

    /**
     * @return Collection|TCos[]
     */
    public function getTCos(): Collection
    {
        return $this->tCos;
    }

    public function addTCo(TCos $tCo): self
    {
        if (!$this->tCos->contains($tCo)) {
            $this->tCos[] = $tCo;
            $tCo->setStaffMember($this);
        }

        return $this;
    }

    public function removeTCo(TCos $tCo): self
    {
        if ($this->tCos->removeElement($tCo)) {
            // set the owning side to null (unless already changed)
            if ($tCo->getStaffMember() === $this) {
                $tCo->setStaffMember(null);
            }
        }

        return $this;
    }


    /**
     * @return Collection|TCecs[]
     */
    public function getTCecs(): Collection
    {
        return $this->tCecs;
    }

    public function addTCec(TCecs $tCec): self
    {
        if (!$this->tCecs->contains($tCec)) {
            $this->tCecs[] = $tCec;
            $tCec->setStaffMember($this);
        }

        return $this;
    }

    public function removeTCec(TCecs $tCec): self
    {
        if ($this->tCecs->removeElement($tCec)) {
            // set the owning side to null (unless already changed)
            if ($tCec->getStaffMember() === $this) {
                $tCec->setStaffMember(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TCountySecretary[]
     */
    public function getTCountySecretaries(): Collection
    {
        return $this->tCountySecretaries;
    }

    public function addTCountySecretary(TCountySecretary $tCountySecretary): self
    {
        if (!$this->tCountySecretaries->contains($tCountySecretary)) {
            $this->tCountySecretaries[] = $tCountySecretary;
            $tCountySecretary->setStaffMember($this);
        }

        return $this;
    }

    public function removeTCountySecretary(TCountySecretary $tCountySecretary): self
    {
        if ($this->tCountySecretaries->removeElement($tCountySecretary)) {
            // set the owning side to null (unless already changed)
            if ($tCountySecretary->getStaffMember() === $this) {
                $tCountySecretary->setStaffMember(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TAppraisals[]
     */
    public function getTAppraisals(): Collection
    {
        return $this->tAppraisals;
    }

    public function addTAppraisal(TAppraisals $tAppraisal): self
    {
        if (!$this->tAppraisals->contains($tAppraisal)) {
            $this->tAppraisals[] = $tAppraisal;
            $tAppraisal->setStaffMember($this);
        }

        return $this;
    }

    public function removeTAppraisal(TAppraisals $tAppraisal): self
    {
        if ($this->tAppraisals->removeElement($tAppraisal)) {
            // set the owning side to null (unless already changed)
            if ($tAppraisal->getStaffMember() === $this) {
                $tAppraisal->setStaffMember(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TDirectors[]
     */
    public function getTDirectors(): Collection
    {
        return $this->tDirectors;
    }

    public function addTDirector(TDirectors $tDirector): self
    {
        if (!$this->tDirectors->contains($tDirector)) {
            $this->tDirectors[] = $tDirector;
            $tDirector->setStaffMember($this);
        }

        return $this;
    }

    public function removeTDirector(TDirectors $tDirector): self
    {
        if ($this->tDirectors->removeElement($tDirector)) {
            // set the owning side to null (unless already changed)
            if ($tDirector->getStaffMember() === $this) {
                $tDirector->setStaffMember(null);
            }
        }

        return $this;
    }

    public function getProfilePhoto(): ?string
    {
        return $this->profilePhoto;
    }

    public function setProfilePhoto(?string $profilePhoto): self
    {
        $this->profilePhoto = $profilePhoto;

        return $this;
    }

    /**
     * @return Collection|TMilestonesNotes[]
     */
    public function getTMilestonesNotes(): Collection
    {
        return $this->tMilestonesNotes;
    }

    public function addTMilestonesNote(TMilestonesNotes $tMilestonesNote): self
    {
        if (!$this->tMilestonesNotes->contains($tMilestonesNote)) {
            $this->tMilestonesNotes[] = $tMilestonesNote;
            $tMilestonesNote->setStaffMember($this);
        }

        return $this;
    }

    public function removeTMilestonesNote(TMilestonesNotes $tMilestonesNote): self
    {
        if ($this->tMilestonesNotes->removeElement($tMilestonesNote)) {
            // set the owning side to null (unless already changed)
            if ($tMilestonesNote->getStaffMember() === $this) {
                $tMilestonesNote->setStaffMember(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TPcActivities[]
     */
    public function getTPcActivities(): Collection
    {
        return $this->tPcActivities;
    }

    public function addTPcActivity(TPcActivities $tPcActivity): self
    {
        if (!$this->tPcActivities->contains($tPcActivity)) {
            $this->tPcActivities[] = $tPcActivity;
            $tPcActivity->setActivityOwner($this);
        }

        return $this;
    }

    public function removeTPcActivity(TPcActivities $tPcActivity): self
    {
        if ($this->tPcActivities->removeElement($tPcActivity)) {
            // set the owning side to null (unless already changed)
            if ($tPcActivity->getActivityOwner() === $this) {
                $tPcActivity->setActivityOwner(null);
            }
        }

        return $this;
    }

}
