<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TCountySectorsAdpProjectsRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_county_sectors_adp_projects:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_county_sectors_adp_projects:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TCountySectorsAdpProjectsRepository::class)
 */

class TCountySectorsAdpProjects
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_county_sectors_adp_projects:read", "t_county_sectors_adp_projects:write", "t_county_departments_adp_projects:read" })
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TFinancialYears::class, inversedBy="tCountySectorsAdpProjects")
     * @Groups({ "t_county_sectors_adp_projects:read", "t_county_sectors_adp_projects:write", "t_county_departments_adp_projects:read" })
     */
    private $financialYear;

    /**
     * @ORM\ManyToOne(targetEntity=TCidps::class, inversedBy="tCountySectorsAdpProjects")
     * @Groups({ "t_county_sectors_adp_projects:read", "t_county_sectors_adp_projects:write" })
     */
    private $cidp;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_county_sectors_adp_projects:read", "t_county_sectors_adp_projects:write" })
     */
    private $target;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_county_sectors_adp_projects:read", "t_county_sectors_adp_projects:write" })
     */
    private $budgetAllocation;

    /**
     * @ORM\OneToMany(targetEntity=TCountyDepartmentsAdpProjects::class, mappedBy="sectorAdpProject")
     * @Groups({ "t_county_sectors_adp_projects:read", "t_county_sectors_adp_projects:write" })
     */
    private $tCountyDepartmentsAdpProjects;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tCountySectorsAdpProjects")
     * @Groups({ "t_county_sectors_adp_projects:read", "t_county_sectors_adp_projects:write" })
     */
    private $sector;

    public function __construct()
    {
        $this->tCountyDepartmentsAdpProjects = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getFinancialYear(): ?TFinancialYears
    {
        return $this->financialYear;
    }

    public function setFinancialYear(?TFinancialYears $financialYear): self
    {
        $this->financialYear = $financialYear;

        return $this;
    }

    public function getCidp(): ?TCidps
    {
        return $this->cidp;
    }

    public function setCidp(?TCidps $cidp): self
    {
        $this->cidp = $cidp;

        return $this;
    }

    public function getTarget(): ?string
    {
        return $this->target;
    }

    public function setTarget(?string $target): self
    {
        $this->target = $target;

        return $this;
    }

    public function getBudgetAllocation(): ?string
    {
        return $this->budgetAllocation;
    }

    public function setBudgetAllocation(?string $budgetAllocation): self
    {
        $this->budgetAllocation = $budgetAllocation;

        return $this;
    }

    /**
     * @return Collection|TCountyDepartmentsAdpProjects[]
     */
    public function getTCountyDepartmentsAdpProjects(): Collection
    {
        return $this->tCountyDepartmentsAdpProjects;
    }

    public function addTCountyDepartmentsAdpProject(TCountyDepartmentsAdpProjects $tCountyDepartmentsAdpProject): self
    {
        if (!$this->tCountyDepartmentsAdpProjects->contains($tCountyDepartmentsAdpProject)) {
            $this->tCountyDepartmentsAdpProjects[] = $tCountyDepartmentsAdpProject;
            $tCountyDepartmentsAdpProject->setSectorAdpProject($this);
        }

        return $this;
    }

    public function removeTCountyDepartmentsAdpProject(TCountyDepartmentsAdpProjects $tCountyDepartmentsAdpProject): self
    {
        if ($this->tCountyDepartmentsAdpProjects->removeElement($tCountyDepartmentsAdpProject)) {
            // set the owning side to null (unless already changed)
            if ($tCountyDepartmentsAdpProject->getSectorAdpProject() === $this) {
                $tCountyDepartmentsAdpProject->setSectorAdpProject(null);
            }
        }

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }
}
