<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TCountyObjectivesRepository;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;
use Doctrine\ORM\Mapping as ORM;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_county_objectives:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_county_objectives:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TCountyObjectivesRepository::class)
 */

class TCountyObjectives
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_county_objectives:read", "t_county_objectives:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="string", length=255, nullable=true)
     * @Groups({ "t_county_objectives:read", "t_county_objectives:write", "t_sector_objectives:read" })
     */
    private $name;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_county_objectives:read", "t_county_objectives:write" })
     */
    private $weight;

    /**
     * @ORM\ManyToOne(targetEntity=TFinancialYears::class, inversedBy="tCountyObjectives")
     * @Groups({ "t_county_objectives:read", "t_county_objectives:write" })
     */
    private $financialYear;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_county_objectives:read", "t_county_objectives:write" })
     */
    private $budgetAllocated;

    public function __construct()
    {
        
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getName(): ?string
    {
        return $this->name;
    }

    public function setName(?string $name): self
    {
        $this->name = $name;

        return $this;
    }

    public function getWeight(): ?string
    {
        return $this->weight;
    }

    public function setWeight(?string $weight): self
    {
        $this->weight = $weight;

        return $this;
    }

    public function getFinancialYear(): ?TFinancialYears
    {
        return $this->financialYear;
    }

    public function setFinancialYear(?TFinancialYears $financialYear): self
    {
        $this->financialYear = $financialYear;

        return $this;
    }

    public function getBudgetAllocated(): ?string
    {
        return $this->budgetAllocated;
    }

    public function setBudgetAllocated(?string $budgetAllocated): self
    {
        $this->budgetAllocated = $budgetAllocated;

        return $this;
    }
}
