<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TCidpsRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_cidps:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_cidps:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "sector": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TCidpsRepository::class)
 */

class TCidps
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_cidps:read", "t_cidps:write", "t_county_sectors_adp_projects:read" })
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TSectorPriorities::class, inversedBy="tCidps")
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $programme;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_cidps:read", "t_cidps:write", "t_county_sectors_adp_projects:read" })
     */
    private $subProgramme;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $keyOutput;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $keyPerformanceIndicator;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $linkageToSdgTargets;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $yearOneTarget;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $yearOneCost;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $yearTwoTarget;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $yearTwoCost;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $yearThreeTarget;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $yearThreeCost;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $yearFourTarget;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $yearFourCost;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $yearFiveTarget;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $yearFiveCost;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $totalBudget;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tCidps")
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $sector;

    /**
     * @ORM\ManyToOne(targetEntity=TSectorObjectives::class, inversedBy="tCidps")
     * @Groups({ "t_cidps:read", "t_cidps:write" })
     */
    private $sectorObjective;

    /**
     * @ORM\OneToMany(targetEntity=TCountySectorsAdpProjects::class, mappedBy="cidp")
     */
    private $tCountySectorsAdpProjects;

    public function __construct()
    {
        $this->tCountySectorsAdpProjects = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getProgramme(): ?TSectorPriorities
    {
        return $this->programme;
    }

    public function setProgramme(?TSectorPriorities $programme): self
    {
        $this->programme = $programme;

        return $this;
    }

    public function getSubProgramme(): ?string
    {
        return $this->subProgramme;
    }

    public function setSubProgramme(?string $subProgramme): self
    {
        $this->subProgramme = $subProgramme;

        return $this;
    }

    public function getKeyOutput(): ?string
    {
        return $this->keyOutput;
    }

    public function setKeyOutput(?string $keyOutput): self
    {
        $this->keyOutput = $keyOutput;

        return $this;
    }

    public function getKeyPerformanceIndicator(): ?string
    {
        return $this->keyPerformanceIndicator;
    }

    public function setKeyPerformanceIndicator(?string $keyPerformanceIndicator): self
    {
        $this->keyPerformanceIndicator = $keyPerformanceIndicator;

        return $this;
    }

    public function getLinkageToSdgTargets(): ?string
    {
        return $this->linkageToSdgTargets;
    }

    public function setLinkageToSdgTargets(?string $linkageToSdgTargets): self
    {
        $this->linkageToSdgTargets = $linkageToSdgTargets;

        return $this;
    }

    public function getYearOneTarget(): ?string
    {
        return $this->yearOneTarget;
    }

    public function setYearOneTarget(?string $yearOneTarget): self
    {
        $this->yearOneTarget = $yearOneTarget;

        return $this;
    }

    public function getYearOneCost(): ?string
    {
        return $this->yearOneCost;
    }

    public function setYearOneCost(?string $yearOneCost): self
    {
        $this->yearOneCost = $yearOneCost;

        return $this;
    }

    public function getYearTwoTarget(): ?string
    {
        return $this->yearTwoTarget;
    }

    public function setYearTwoTarget(?string $yearTwoTarget): self
    {
        $this->yearTwoTarget = $yearTwoTarget;

        return $this;
    }

    public function getYearTwoCost(): ?string
    {
        return $this->yearTwoCost;
    }

    public function setYearTwoCost(?string $yearTwoCost): self
    {
        $this->yearTwoCost = $yearTwoCost;

        return $this;
    }

    public function getYearThreeTarget(): ?string
    {
        return $this->yearThreeTarget;
    }

    public function setYearThreeTarget(?string $yearThreeTarget): self
    {
        $this->yearThreeTarget = $yearThreeTarget;

        return $this;
    }

    public function getYearThreeCost(): ?string
    {
        return $this->yearThreeCost;
    }

    public function setYearThreeCost(?string $yearThreeCost): self
    {
        $this->yearThreeCost = $yearThreeCost;

        return $this;
    }

    public function getYearFourTarget(): ?string
    {
        return $this->yearFourTarget;
    }

    public function setYearFourTarget(?string $yearFourTarget): self
    {
        $this->yearFourTarget = $yearFourTarget;

        return $this;
    }

    public function getYearFourCost(): ?string
    {
        return $this->yearFourCost;
    }

    public function setYearFourCost(?string $yearFourCost): self
    {
        $this->yearFourCost = $yearFourCost;

        return $this;
    }

    public function getYearFiveTarget(): ?string
    {
        return $this->yearFiveTarget;
    }

    public function setYearFiveTarget(?string $yearFiveTarget): self
    {
        $this->yearFiveTarget = $yearFiveTarget;

        return $this;
    }

    public function getYearFiveCost(): ?string
    {
        return $this->yearFiveCost;
    }

    public function setYearFiveCost(?string $yearFiveCost): self
    {
        $this->yearFiveCost = $yearFiveCost;

        return $this;
    }

    public function getTotalBudget(): ?string
    {
        return $this->totalBudget;
    }

    public function setTotalBudget(?string $totalBudget): self
    {
        $this->totalBudget = $totalBudget;

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }

    public function getSectorObjective(): ?TSectorObjectives
    {
        return $this->sectorObjective;
    }

    public function setSectorObjective(?TSectorObjectives $sectorObjective): self
    {
        $this->sectorObjective = $sectorObjective;

        return $this;
    }

    /**
     * @return Collection|TCountySectorsAdpProjects[]
     */
    public function getTCountySectorsAdpProjects(): Collection
    {
        return $this->tCountySectorsAdpProjects;
    }

    public function addTCountySectorsAdpProject(TCountySectorsAdpProjects $tCountySectorsAdpProject): self
    {
        if (!$this->tCountySectorsAdpProjects->contains($tCountySectorsAdpProject)) {
            $this->tCountySectorsAdpProjects[] = $tCountySectorsAdpProject;
            $tCountySectorsAdpProject->setCidp($this);
        }

        return $this;
    }

    public function removeTCountySectorsAdpProject(TCountySectorsAdpProjects $tCountySectorsAdpProject): self
    {
        if ($this->tCountySectorsAdpProjects->removeElement($tCountySectorsAdpProject)) {
            // set the owning side to null (unless already changed)
            if ($tCountySectorsAdpProject->getCidp() === $this) {
                $tCountySectorsAdpProject->setCidp(null);
            }
        }

        return $this;
    }
}
