<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TCecsRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_cecs:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_cecs:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "sector": "exact", "currentStaff": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TCecsRepository::class)
 */

class TCecs
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_cecs:read", "t_cecs:write", "t_pcs:read" })
     */
    private $id;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tCecs")
     * @Groups({ "t_cecs:read", "t_cecs:write", "t_pcs:read" })
     */
    private $sector;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_cecs:read", "t_cecs:write" })
     */
    private $currentStaff;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyStaffMembers::class, inversedBy="tCecs")
     * @Groups({ "t_cecs:read", "t_cecs:write", "t_pcs:read" })
     */
    private $staffMember;

    /**
     * @ORM\OneToMany(targetEntity=TPcs::class, mappedBy="cecSignsOwnPc")
     */
    private $tPcs;

    /**
     * @ORM\OneToMany(targetEntity=TPcs::class, mappedBy="cecWithCo")
     */
    private $cecWithCo;

    /**
     * @ORM\OneToMany(targetEntity=TPcs::class, mappedBy="cecWitnessDirPc")
     */
    private $cecWitnessDirPc;

    public function __construct()
    {
        $this->tPcs = new ArrayCollection();
        $this->cecWithCo = new ArrayCollection();
        $this->cecWitnessDirPc = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }

    public function getCurrentStaff(): ?string
    {
        return $this->currentStaff;
    }

    public function setCurrentStaff(?string $currentStaff): self
    {
        $this->currentStaff = $currentStaff;

        return $this;
    }

    public function getStaffMember(): ?TCountyStaffMembers
    {
        return $this->staffMember;
    }

    public function setStaffMember(?TCountyStaffMembers $staffMember): self
    {
        $this->staffMember = $staffMember;

        return $this;
    }

    /**
     * @return Collection|TPcs[]
     */
    public function getTPcs(): Collection
    {
        return $this->tPcs;
    }

    public function addTPc(TPcs $tPc): self
    {
        if (!$this->tPcs->contains($tPc)) {
            $this->tPcs[] = $tPc;
            $tPc->setCecSignsOwnPc($this);
        }

        return $this;
    }

    public function removeTPc(TPcs $tPc): self
    {
        if ($this->tPcs->removeElement($tPc)) {
            // set the owning side to null (unless already changed)
            if ($tPc->getCecSignsOwnPc() === $this) {
                $tPc->setCecSignsOwnPc(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TPcs[]
     */
    public function getCecWithCo(): Collection
    {
        return $this->cecWithCo;
    }

    public function addCecWithCo(TPcs $cecWithCo): self
    {
        if (!$this->cecWithCo->contains($cecWithCo)) {
            $this->cecWithCo[] = $cecWithCo;
            $cecWithCo->setCecWithCo($this);
        }

        return $this;
    }

    public function removeCecWithCo(TPcs $cecWithCo): self
    {
        if ($this->cecWithCo->removeElement($cecWithCo)) {
            // set the owning side to null (unless already changed)
            if ($cecWithCo->getCecWithCo() === $this) {
                $cecWithCo->setCecWithCo(null);
            }
        }

        return $this;
    }

    /**
     * @return Collection|TPcs[]
     */
    public function getCecWitnessDirPc(): Collection
    {
        return $this->cecWitnessDirPc;
    }

    public function addCecWitnessDirPc(TPcs $cecWitnessDirPc): self
    {
        if (!$this->cecWitnessDirPc->contains($cecWitnessDirPc)) {
            $this->cecWitnessDirPc[] = $cecWitnessDirPc;
            $cecWitnessDirPc->setCecWitnessDirPc($this);
        }

        return $this;
    }

    public function removeCecWitnessDirPc(TPcs $cecWitnessDirPc): self
    {
        if ($this->cecWitnessDirPc->removeElement($cecWitnessDirPc)) {
            // set the owning side to null (unless already changed)
            if ($cecWitnessDirPc->getCecWitnessDirPc() === $this) {
                $cecWitnessDirPc->setCecWitnessDirPc(null);
            }
        }

        return $this;
    }

   
}
