<?php

namespace App\Entity;

use ApiPlatform\Core\Annotation\ApiResource;
use App\Repository\TAppraisalsRepository;
use Doctrine\ORM\Mapping as ORM;
use Doctrine\Common\Collections\ArrayCollection;
use Doctrine\Common\Collections\Collection;

use ApiPlatform\Core\Annotation\ApiFilter;
use ApiPlatform\Core\Bridge\Doctrine\Orm\Filter\SearchFilter;
use ApiPlatform\Core\Serializer\Filter\PropertyFilter;
use Symfony\Component\Serializer\Annotation\Groups;

/**
 * @ApiResource(
 *    normalizationContext={"groups"={"t_appraisals:read"}, "enable_max_depth"="true", "swagger_definition_name"="Read"},
 *    denormalizationContext={"groups"={"t_appraisals:write"}, "swagger_definition_name"="Write"}
 * )
 * @ApiFilter(SearchFilter::class, properties={ "id": "exact", "directorate": "exact", "director": "exact", "progressStatus": "exact" })
 * @ApiFilter(PropertyFilter::class)
 * @ORM\Entity(repositoryClass=TAppraisalsRepository::class)
 */

class TAppraisals
{
    /**
     * @ORM\Id
     * @ORM\GeneratedValue
     * @ORM\Column(type="integer")
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $id;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $startDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $endDate;

    /**
     * @ORM\ManyToOne(targetEntity=TCountyStaffMembers::class, inversedBy="tAppraisals")
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $staffMember;

    /**
     * @ORM\ManyToOne(targetEntity=TDirectors::class, inversedBy="tAppraisals")
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $director;

    /**
     * @ORM\ManyToOne(targetEntity=TCountySectors::class, inversedBy="tAppraisals")
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $sector;

    /**
     * @ORM\ManyToOne(targetEntity=TDirectorates::class, inversedBy="tAppraisals")
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $directorate;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $appraiseeComments;

    /**
     * @ORM\Column(type="text", nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $supervisorComments;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $appraiseeSign;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $appraiseeSignDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $supervisorSignDate;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $chiefOfficerSign;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $chiefOfficerSignDate;

    /**
     * @ORM\Column(type="date", nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $creationDate;

    /**
     * @ORM\ManyToOne(targetEntity=TWorkFlowStages::class, inversedBy="tAppraisals")
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $workflowStage;

    /**
     * @ORM\OneToMany(targetEntity=TAppraisalDevelopmentPlans::class, mappedBy="appraisal")
     */
    private $tAppraisalDevelopmentPlans;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $supervisorSign;

    /**
     * @ORM\ManyToOne(targetEntity=TFinancialYears::class, inversedBy="tAppraisals")
     */
    private $financialYear;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $valuesIntegrity;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $valuesRespect;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $valuesMeritocracy;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $valuesFairness;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $valuesConfidentiality;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $coreCitizenFocus;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $coreProfessionalism;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $coreTechnical;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $coreCommunication;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $coreTeamWork;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $coreTimeManagement;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $coreLearning;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $totalTargetScore;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $totalCoreValuesScore;

    /**
     * @ORM\Column(type="decimal", precision=60, scale=2, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $totalPerformance;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $valuesIntegrityName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $valuesRespectName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $valuesMeritocracyName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $valuesFairnessName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $valuesConfidentialityName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $coreCitizenFocusName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $coreProfessionalismName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $coreTechnicalName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $coreCommunicationName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $coreTeamWorkName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $coreTimeManagementName;

    /**
     * @ORM\Column(type="string", length=60, nullable=true)
     * @Groups({ "t_appraisals:read", "t_appraisals:write" })
     */
    private $coreLearningName;

    public function __construct()
    {
        $this->tAppraisalDevelopmentPlans = new ArrayCollection();
    }

    public function getId(): ?int
    {
        return $this->id;
    }

    public function getStartDate(): ?\DateTimeInterface
    {
        return $this->startDate;
    }

    public function setStartDate(?\DateTimeInterface $startDate): self
    {
        $this->startDate = $startDate;

        return $this;
    }

    public function getEndDate(): ?\DateTimeInterface
    {
        return $this->endDate;
    }

    public function setEndDate(?\DateTimeInterface $endDate): self
    {
        $this->endDate = $endDate;

        return $this;
    }

    public function getStaffMember(): ?TCountyStaffMembers
    {
        return $this->staffMember;
    }

    public function setStaffMember(?TCountyStaffMembers $staffMember): self
    {
        $this->staffMember = $staffMember;

        return $this;
    }

    public function getDirector(): ?TDirectors
    {
        return $this->director;
    }

    public function setDirector(?TDirectors $director): self
    {
        $this->director = $director;

        return $this;
    }

    public function getSector(): ?TCountySectors
    {
        return $this->sector;
    }

    public function setSector(?TCountySectors $sector): self
    {
        $this->sector = $sector;

        return $this;
    }

    public function getDirectorate(): ?TDirectorates
    {
        return $this->directorate;
    }

    public function setDirectorate(?TDirectorates $directorate): self
    {
        $this->directorate = $directorate;

        return $this;
    }

    public function getAppraiseeComments(): ?string
    {
        return $this->appraiseeComments;
    }

    public function setAppraiseeComments(?string $appraiseeComments): self
    {
        $this->appraiseeComments = $appraiseeComments;

        return $this;
    }

    public function getSupervisorComments(): ?string
    {
        return $this->supervisorComments;
    }

    public function setSupervisorComments(?string $supervisorComments): self
    {
        $this->supervisorComments = $supervisorComments;

        return $this;
    }

    public function getAppraiseeSign(): ?string
    {
        return $this->appraiseeSign;
    }

    public function setAppraiseeSign(?string $appraiseeSign): self
    {
        $this->appraiseeSign = $appraiseeSign;

        return $this;
    }

    public function getAppraiseeSignDate(): ?\DateTimeInterface
    {
        return $this->appraiseeSignDate;
    }

    public function setAppraiseeSignDate(?\DateTimeInterface $appraiseeSignDate): self
    {
        $this->appraiseeSignDate = $appraiseeSignDate;

        return $this;
    }

    public function getSupervisorSignDate(): ?\DateTimeInterface
    {
        return $this->supervisorSignDate;
    }

    public function setSupervisorSignDate(?\DateTimeInterface $supervisorSignDate): self
    {
        $this->supervisorSignDate = $supervisorSignDate;

        return $this;
    }

    public function getChiefOfficerSign(): ?string
    {
        return $this->chiefOfficerSign;
    }

    public function setChiefOfficerSign(?string $chiefOfficerSign): self
    {
        $this->chiefOfficerSign = $chiefOfficerSign;

        return $this;
    }

    public function getChiefOfficerSignDate(): ?\DateTimeInterface
    {
        return $this->chiefOfficerSignDate;
    }

    public function setChiefOfficerSignDate(?\DateTimeInterface $chiefOfficerSignDate): self
    {
        $this->chiefOfficerSignDate = $chiefOfficerSignDate;

        return $this;
    }

    public function getCreationDate(): ?\DateTimeInterface
    {
        return $this->creationDate;
    }

    public function setCreationDate(?\DateTimeInterface $creationDate): self
    {
        $this->creationDate = $creationDate;

        return $this;
    }

    public function getWorkflowStage(): ?TWorkFlowStages
    {
        return $this->workflowStage;
    }

    public function setWorkflowStage(?TWorkFlowStages $workflowStage): self
    {
        $this->workflowStage = $workflowStage;

        return $this;
    }

    /**
     * @return Collection|TAppraisalDevelopmentPlans[]
     */
    public function getTAppraisalDevelopmentPlans(): Collection
    {
        return $this->tAppraisalDevelopmentPlans;
    }

    public function addTAppraisalDevelopmentPlan(TAppraisalDevelopmentPlans $tAppraisalDevelopmentPlan): self
    {
        if (!$this->tAppraisalDevelopmentPlans->contains($tAppraisalDevelopmentPlan)) {
            $this->tAppraisalDevelopmentPlans[] = $tAppraisalDevelopmentPlan;
            $tAppraisalDevelopmentPlan->setAppraisal($this);
        }

        return $this;
    }

    public function removeTAppraisalDevelopmentPlan(TAppraisalDevelopmentPlans $tAppraisalDevelopmentPlan): self
    {
        if ($this->tAppraisalDevelopmentPlans->removeElement($tAppraisalDevelopmentPlan)) {
            // set the owning side to null (unless already changed)
            if ($tAppraisalDevelopmentPlan->getAppraisal() === $this) {
                $tAppraisalDevelopmentPlan->setAppraisal(null);
            }
        }

        return $this;
    }

    public function getSupervisorSign(): ?string
    {
        return $this->supervisorSign;
    }

    public function setSupervisorSign(?string $supervisorSign): self
    {
        $this->supervisorSign = $supervisorSign;

        return $this;
    }

    public function getFinancialYear(): ?TFinancialYears
    {
        return $this->financialYear;
    }

    public function setFinancialYear(?TFinancialYears $financialYear): self
    {
        $this->financialYear = $financialYear;

        return $this;
    }

    public function getValuesIntegrity(): ?string
    {
        return $this->valuesIntegrity;
    }

    public function setValuesIntegrity(?string $valuesIntegrity): self
    {
        $this->valuesIntegrity = $valuesIntegrity;

        return $this;
    }

    public function getValuesRespect(): ?string
    {
        return $this->valuesRespect;
    }

    public function setValuesRespect(?string $valuesRespect): self
    {
        $this->valuesRespect = $valuesRespect;

        return $this;
    }

    public function getValuesMeritocracy(): ?string
    {
        return $this->valuesMeritocracy;
    }

    public function setValuesMeritocracy(?string $valuesMeritocracy): self
    {
        $this->valuesMeritocracy = $valuesMeritocracy;

        return $this;
    }

    public function getValuesFairness(): ?string
    {
        return $this->valuesFairness;
    }

    public function setValuesFairness(?string $valuesFairness): self
    {
        $this->valuesFairness = $valuesFairness;

        return $this;
    }

    public function getValuesConfidentiality(): ?string
    {
        return $this->valuesConfidentiality;
    }

    public function setValuesConfidentiality(?string $valuesConfidentiality): self
    {
        $this->valuesConfidentiality = $valuesConfidentiality;

        return $this;
    }

    public function getCoreCitizenFocus(): ?string
    {
        return $this->coreCitizenFocus;
    }

    public function setCoreCitizenFocus(?string $coreCitizenFocus): self
    {
        $this->coreCitizenFocus = $coreCitizenFocus;

        return $this;
    }

    public function getCoreProfessionalism(): ?string
    {
        return $this->coreProfessionalism;
    }

    public function setCoreProfessionalism(?string $coreProfessionalism): self
    {
        $this->coreProfessionalism = $coreProfessionalism;

        return $this;
    }

    public function getCoreTechnical(): ?string
    {
        return $this->coreTechnical;
    }

    public function setCoreTechnical(?string $coreTechnical): self
    {
        $this->coreTechnical = $coreTechnical;

        return $this;
    }

    public function getCoreCommunication(): ?string
    {
        return $this->coreCommunication;
    }

    public function setCoreCommunication(?string $coreCommunication): self
    {
        $this->coreCommunication = $coreCommunication;

        return $this;
    }

    public function getCoreTeamWork(): ?string
    {
        return $this->coreTeamWork;
    }

    public function setCoreTeamWork(?string $coreTeamWork): self
    {
        $this->coreTeamWork = $coreTeamWork;

        return $this;
    }

    public function getCoreTimeManagement(): ?string
    {
        return $this->coreTimeManagement;
    }

    public function setCoreTimeManagement(?string $coreTimeManagement): self
    {
        $this->coreTimeManagement = $coreTimeManagement;

        return $this;
    }

    public function getCoreLearning(): ?string
    {
        return $this->coreLearning;
    }

    public function setCoreLearning(?string $coreLearning): self
    {
        $this->coreLearning = $coreLearning;

        return $this;
    }

    public function getTotalTargetScore(): ?string
    {
        return $this->totalTargetScore;
    }

    public function setTotalTargetScore(?string $totalTargetScore): self
    {
        $this->totalTargetScore = $totalTargetScore;

        return $this;
    }

    public function getTotalCoreValuesScore(): ?string
    {
        return $this->totalCoreValuesScore;
    }

    public function setTotalCoreValuesScore(?string $totalCoreValuesScore): self
    {
        $this->totalCoreValuesScore = $totalCoreValuesScore;

        return $this;
    }

    public function getTotalPerformance(): ?string
    {
        return $this->totalPerformance;
    }

    public function setTotalPerformance(?string $totalPerformance): self
    {
        $this->totalPerformance = $totalPerformance;

        return $this;
    }

    public function getValuesIntegrityName(): ?string
    {
        return $this->valuesIntegrityName;
    }

    public function setValuesIntegrityName(?string $valuesIntegrityName): self
    {
        $this->valuesIntegrityName = $valuesIntegrityName;

        return $this;
    }

    public function getValuesRespectName(): ?string
    {
        return $this->valuesRespectName;
    }

    public function setValuesRespectName(?string $valuesRespectName): self
    {
        $this->valuesRespectName = $valuesRespectName;

        return $this;
    }

    public function getValuesMeritocracyName(): ?string
    {
        return $this->valuesMeritocracyName;
    }

    public function setValuesMeritocracyName(?string $valuesMeritocracyName): self
    {
        $this->valuesMeritocracyName = $valuesMeritocracyName;

        return $this;
    }

    public function getValuesFairnessName(): ?string
    {
        return $this->valuesFairnessName;
    }

    public function setValuesFairnessName(?string $valuesFairnessName): self
    {
        $this->valuesFairnessName = $valuesFairnessName;

        return $this;
    }

    public function getValuesConfidentialityName(): ?string
    {
        return $this->valuesConfidentialityName;
    }

    public function setValuesConfidentialityName(?string $valuesConfidentialityName): self
    {
        $this->valuesConfidentialityName = $valuesConfidentialityName;

        return $this;
    }

    public function getCoreCitizenFocusName(): ?string
    {
        return $this->coreCitizenFocusName;
    }

    public function setCoreCitizenFocusName(?string $coreCitizenFocusName): self
    {
        $this->coreCitizenFocusName = $coreCitizenFocusName;

        return $this;
    }

    public function getCoreProfessionalismName(): ?string
    {
        return $this->coreProfessionalismName;
    }

    public function setCoreProfessionalismName(?string $coreProfessionalismName): self
    {
        $this->coreProfessionalismName = $coreProfessionalismName;

        return $this;
    }

    public function getCoreTechnicalName(): ?string
    {
        return $this->coreTechnicalName;
    }

    public function setCoreTechnicalName(?string $coreTechnicalName): self
    {
        $this->coreTechnicalName = $coreTechnicalName;

        return $this;
    }

    public function getCoreCommunicationName(): ?string
    {
        return $this->coreCommunicationName;
    }

    public function setCoreCommunicationName(?string $coreCommunicationName): self
    {
        $this->coreCommunicationName = $coreCommunicationName;

        return $this;
    }

    public function getCoreTeamWorkName(): ?string
    {
        return $this->coreTeamWorkName;
    }

    public function setCoreTeamWorkName(?string $coreTeamWorkName): self
    {
        $this->coreTeamWorkName = $coreTeamWorkName;

        return $this;
    }

    public function getCoreTimeManagementName(): ?string
    {
        return $this->coreTimeManagementName;
    }

    public function setCoreTimeManagementName(?string $coreTimeManagementName): self
    {
        $this->coreTimeManagementName = $coreTimeManagementName;

        return $this;
    }

    public function getCoreLearningName(): ?string
    {
        return $this->coreLearningName;
    }

    public function setCoreLearningName(?string $coreLearningName): self
    {
        $this->coreLearningName = $coreLearningName;

        return $this;
    }
}
